<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\VideoTamplate;
use App\Models\VideoTamplateCategory;
use App\Models\Setting;
use App\Models\Language;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use ZipArchive;

class VideoTamplateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['posts'] = VideoTamplate::orderBy('id', 'DESC')->paginate(12);
        return view('videoTamplate.index',$data);
    }
    
    public function filterby_type($type)
    {
        $data['posts'] = VideoTamplate::where('type',$type)->orderBy('id', 'DESC')->paginate(12);
        $data['type'] = $type;
         
        return view("videoTamplate.index", $data);
    }
    
    public function video_status(Request $request)
    {
        // echo("okk");
        $festivals = VideoTamplate::find($request->get("id"));
        $festivals->status = ($request->get("checked")=="true")?0:1;
        $festivals->save();
    }
    
    
    public function premium_action(Request $request)
    {
        $festivals = VideoTamplate::find($request->get("id"));
        $festivals->premium = $request->get("type");
        $festivals->save();
    }
    
    public function video_action(Request $request)
    {
        $ids = explode(",",$request->posts_ids);
        if($request->posts_ids != null)
        {
            if($request->action_type == "enable")
            {
                foreach($ids as $id){
                    $posts = VideoTamplate::find($id);
                    $posts->status = 0;
                    $posts->save();
                }
            }
    
            if($request->action_type == "disable")
            {
                foreach($ids as $id){
                    $posts = VideoTamplate::find($id);
                    $posts->status = 1;
                    $posts->save();
                }
            }
    
            if($request->action_type == "delete")
            {
                foreach($ids as $id){
                    
                    $posts = VideoTamplate::find($id);
                    @unlink($posts->video_url);
                    @unlink($posts->zip_url);
                    VideoTamplate::find($id)->delete();
                    
                }
            }
        }
        return redirect()->route("videotamplate.index");
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['languages'] = Language::where('status','0')->get();
        $data['categories'] = VideoTamplateCategory::where('status','0')->get();
        
        return view('videoTamplate.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
             'video' => 'required|mimes:mp4,ogx,oga,ogv,ogg,webm|max:30720',
             'zip' => 'required',
             'title' => 'required',
             'type' => 'required',
             'category' => 'required',
             'language' => 'required',
        ]);
        
        $video = new VideoTamplate();
        $video->title = $request->get("title");
        $video->category_id = $request->get("category");
        $video->type = $request->get("type");
        $video->language = $request->get("language");
        
        
        if ($request->file("zip") && $request->file('zip')->isValid()) {
            
            $zipFile = $request->file("zip");
            $previewFile = $request->file('zip_preview');
            
            $ZipfileOriginalName = pathinfo($zipFile->getClientOriginalName(), PATHINFO_FILENAME);
            
            $zipExtension = $zipFile->getClientOriginalExtension();
            $previewExtension = $previewFile->getClientOriginalExtension();
            
            $zipFileName = $ZipfileOriginalName. '.' .$zipExtension;
            $previewFileName = 'preview'. '.' .$previewExtension;
            
            $zipFile->move('uploads/templates_animated/', $zipFileName);
            
            $zipPath = 'uploads/templates_animated/'.$ZipfileOriginalName. '/' .$zipFileName;
            $previewZipPath = 'uploads/templates_animated/'.$ZipfileOriginalName. '/' .$previewFileName;

            $fileLocation = public_path('uploads/templates_animated/' .$zipFileName);
            $destinationPath = public_path('uploads/templates_animated/');
            
            $zip = new ZipArchive;
            if ($zip->open($fileLocation) == true) {
                
                $zip->extractTo($destinationPath);
                $zip->close();
                
                
                
                if(Setting::getValue('storage_type') == "digitalOccean"){
                    Storage::disk('spaces')->put('uploads/templates_animated/'.$ZipfileOriginalName.$zipFileName, file_get_contents($zipFile),'public');
                    Storage::disk('spaces')->put('uploads/templates_animated/'.$ZipfileOriginalName.$previewFileName, file_get_contents($previewFile),'public');
                    
                    $zipPath = env("DO_SPACES_URL").'uploads/templates_animated/'.$ZipfileOriginalName.$zipFileName;
                    $previewZipPath = env("DO_SPACES_URL").'uploads/templates_animated/'.$ZipfileOriginalName.$previewFileName;
                    
                }else{
                    File::move(public_path().'uploads/templates_animated/'. $zipFileName, $destinationPath .$ZipfileOriginalName .'/'. $zipFileName);
                    $previewFile->move('./uploads/templates_animated/'. $ZipfileOriginalName, $previewFileName);
                }
            }
            
            $video->zip_path_preview = $previewZipPath;
            $video->zip_link = $zipPath;
            $video->template_json = File::get(public_path().'uploads/templates_animated/'.$ZipfileOriginalName.'/template.json');
        }
        if ($request->file("video") && $request->file('video')->isValid()) {
            
            $videof = $request->file("video");
            
            $extension = $videof->getClientOriginalExtension();
            $fileName = Str::uuid() . '.' . $extension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                $item_url = Storage::disk('spaces')->put('uploads/video/'.$fileName, file_get_contents($videof),'public');
                $item_url = env("DO_SPACES_URL").'/uploads/video/'.$fileName;
            }else{
                $videof->move('uploads/video', $fileName);
                $item_url = 'uploads/video/'.$fileName;
            }
            
            $video->video_url = $item_url;
            
        }
        $video->save();
        return redirect()->route('videotamplate.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['video'] = VideoTamplate::find($id);
        $data['languages'] = Language::where('status','0')->get();
        $data['categories'] = VideoTamplateCategory::where('status','0')->get();
        return view('videoTamplate.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
             'title' => 'required',
             'type' => 'required',
             'category' => 'required',
             'language' => 'required',
        ]);
        
        $video = VideoTamplate::find($id);
        $video->title = $request->get("title");
        $video->category_id = $request->get("category");
        $video->type = $request->get("type");
        $video->language = $request->get("language");
        
        if ($request->file("video") && $request->file('video')->isValid()) {
            
            $videof = $request->file("video");
            
            $extension = $videof->getClientOriginalExtension();
            $fileName = Str::uuid() . '.' . $extension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                $item_url = Storage::disk('spaces')->put('uploads/video/'.$fileName, file_get_contents($videof),'public');
                $item_url = env("DO_SPACES_URL").'/uploads/video/'.$fileName;
            }else{
                $videof->move('uploads/video', $fileName);
                $item_url = 'uploads/video/'.$fileName;
                @unlink($video->video_url);
            }
            
            $video->video_url = $item_url;
        }
       
        $video->save();
        return redirect()->route('videotamplate.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $posts = videoTamplate::find($id);
        @unlink($posts->video_url);
        @unlink($posts->zip_url);

        videoTamplate::find($id)->delete();
        return redirect()->route('videotamplate.index');
    }
}
