<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShortsCategory extends Model
{
    use HasFactory;
    
    protected $table = 'shorts_category';
    
    protected $fillable = [
        'name',
        'thumbnail',
        'status',
        'orders'
    ];
    
    /**
     * Get all active shorts videos for this category
     */
    public function videos()
    {
        return $this->hasMany(ShortsVideo::class, 'category_id', 'id')
                    ->where('status', 'active');
    }
    
    /**
     * Get all shorts videos for this category (including inactive)
     */
    public function allVideos()
    {
        return $this->hasMany(ShortsVideo::class, 'category_id', 'id');
    }
}
