@extends('main')

@section('content')
    
    <div class="row">
        <div class="col-12">
            <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-header pb-0">
              <div class="d-flex align-items-center">
                <p class="mb-0 font-weight-bolder">Edit Shorts Category</p>
                <a href="{{ route('shortscategory.index') }}" class="btn btn-secondary btn-sm ms-auto">
                    <i class="fas fa-arrow-left"></i> Back
                </a>
              </div>
            </div>
            <div class="card-body">
                <form method="post" action="{{ route('shortscategory.update', $category->id) }}" id="editform">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="title" class="form-control-label">Category Name <span class="text-danger">*</span></label>
                            <input class="form-control @error('title') is-invalid @enderror" 
                                   name="title" 
                                   type="text" 
                                   placeholder="e.g. Festival, Comedy, Dance" 
                                   value="{{ old('title', $category->name) }}"
                                   required>
                            @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Enter category name (e.g., Festival, Comedy, Dance, Music, etc.)
                            </small>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="videos_count" class="form-control-label">Videos in this Category</label>
                            <input class="form-control" 
                                   type="text" 
                                   value="{{ $category->allVideos()->count() }} video(s)"
                                   disabled>
                            <small class="form-text text-muted">
                                @if($category->allVideos()->count() > 0)
                                    <span class="text-warning"><i class="fas fa-exclamation-triangle"></i> This category has {{ $category->allVideos()->count() }} video(s). Deleting will require reassigning videos first.</span>
                                @else
                                    <span class="text-success"><i class="fas fa-check-circle"></i> No videos in this category yet.</span>
                                @endif
                            </small>
                          </div>
                        </div>
                        
                        <div class="col-md-12">
                            <hr>
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> <strong>Note:</strong> Changing the category name will update it for all videos assigned to this category.
                            </div>
                        </div>
                        
                        <div class="col-md-12" >
                          <div class="form-group">
                              
                              @if(Session::get('admin_type') == "Demo")
                              <div class="btn btn-primary col-md-6 demo_action">Update</div>
                              @else
                              <button class="btn btn-primary col-md-6" type="submit">
                                  <i class="fas fa-save"></i> Update Category
                              </button>
                              @endif
                            
                            <a href="{{ route('shortscategory.index') }}" class="btn btn-secondary col-md-3">Cancel</a>
                          </div>
                        </div>
                     
                    </div>
                </form>
            </div>
          </div>
        </div>
        
      </div>
        </div>
    </div>

@endsection
